// Header File
// Created 02/01/2004; 16:45:52
//Gestion entrs dans le jeu...

#define START_RACKET_XPOS					97
#define START_RACKET_YPOS					184

#define START_BILLE_XPOS					START_RACKET_XPOS+12
#define START_BILLE_YPOS					START_RACKET_YPOS-BILLE_SIZEY

//Intialize le jeu (HUMAIN0)
void GAME_CreateRacketHumain0 (void)
{
	//Le jeu n'a pas commenc
	StartGameForHumain0=FALSE;
	EndAnimForHumain0=FALSE;
	EndCounterLogo=FALSE;
	StartInt1=TRUE;
	COUNTER_LOGO=0;
	
	//Initialisation scrolling level
	InitScrollingLevel ();
	
	//Cration de a raquette
	CREATE_ANIM_RACKET_NEW (START_RACKET_XPOS,START_RACKET_YPOS);
	
	//Efface bonus
	DeleteAllBonus ();
	
	//Racket  l'humain0
	HUMAIN0=nbrRacket-1;
}

//Crer la bille
void GAME_CreateBilleHumain0 (void)
{
	//Si joueur existe ou compteurs non finie
	if ((!EndAnimForHumain0) || (StartGameForHumain0) || (!EndCounterLogo)) return;
		
	//Cration de la Bille
	NewBille (START_BILLE_XPOS,START_BILLE_YPOS,50,DEFAULT_SPEED_BILLES,BILLE_NOFIRE,HUMAIN0);
	
	//Coller la Bille
	Bonus_ActivateColle (HUMAIN0);
	Bonus_RacketColle (HUMAIN0,nbrBille-1);
	
	//Active joueur
	StartGameForHumain0=TRUE;
	EndAnimForHumain0=FALSE;
	LanceBille=FALSE;
}

//Vrifie le nombres de Billes du joueur 0
void CheckBillesPlayer (unsigned char item)
{
	unsigned char nbille=0;
	
	//Le joueur n'existe plus
	if ((item==0xFF) || (Racket [item]->size==7) || !StartGameForHumain0 || EndLevel) return;
	
	//Parcours Billes
	for (int i=0;i<nbrBille;i++)
	{
		if (Bille [i]->n_racket==item)
			{nbille++; break;}
	}
	
	//Plus de Billes
	if (!nbille) {
		CREATE_ANIM_RACKET_DEAD (item);}	
}

//Dessine logo
void GAME_DrawLogo (void)
{
	unsigned char logo;
	
	if (EndCounterLogo) return;
	
	if ((LEVEL==1) || (LEVEL==18)) logo=1;
	else if ((LEVEL==17) || (LEVEL==34)) logo=0;
	else if (LEVEL<17)
		logo=3-LEVEL_DIR;
	else
		logo=5-LEVEL_DIR;
	
	//Affiche logo	
	DrawLogo (SPRITE_LOGO [logo],ScreenBuffer);
	
	//Affiche round
	Font0_DrawString (81,161,"ROUND",ScreenBuffer);
	
	//Afficher chiffres
	if (LEVEL<10)
	{
		Font0_DrawString (129,161,"0",ScreenBuffer);
		Font0_DrawNumber (137,161,LEVEL,ScreenBuffer);
	}
	else
		Font0_DrawNumber (129,161,LEVEL,ScreenBuffer);
		
	//Afficher READY
	Font0_DrawString (92,173,"READY",ScreenBuffer);
	
	//Centrage TI89
	xScroll=32;
}

//Perd une vie
void GAME_Lifes (void)
{
	//Si humain non mort
	if ((HUMAIN0!=0xFF) || EndLevel) return;
	
	//Plus de vie
	if (!nbrLifes) 
	{
		//GAME OVER
		Font0_DrawString (76,161,"GAME OVER",ScreenBuffer);
		
		//Centrage TI89
		xScroll=32;
		return;
	}
	
	//Vie en moins
	nbrLifes--;
	DrawLifes ();
	
	//Redessine bordures...
	ENV_Prepare ();
	DrawMap ();
	ENV_EndPrepare ();
	
	//Dessine screen et MAP
	ENV_DrawScreenAndMap ();
	CenterScrolling ();
	ShowScreenBuffer ();
	
	//Crer joueur
	GAME_CreateRacketHumain0 ();
}